#ifndef _DIALOGS_MAIN_H
#define _DIALOGS_MAIN_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MDI.RecvEdit_hWnd = GetDlgItem(xHandle, IDC_RECVLIST);

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CTLCOLORSTATIC)
	{
		if((HANDLE)lParam == MDI.RecvEdit_hWnd)
            return Set_Color(RGB(0, 0, 0), RGB(255, 255, 255), wParam);

        return FALSE;
    }

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_CONNECTION_CONNECT)
        {
            Client_Thread_Handle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)Client_Thread, (LPVOID) 0, 0, (LPDWORD) &Client_Thread_ID);
            return TRUE;
        }

        if(wParam == ID_CONNECTION_DISCONNECT)
        {
            MyClient.DisconnectClient();
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

